import Mapper

# TAGS INDICATE IDENTIAL SHEETS
# NUMBERS are completely unconstrained
# LETTERS enforce internal symmetry
# < indicates a tile, with the arrow pointed in direction of polarization and feed
# X indicates an empty gap
# || or = (double lines) imply mirror symmetry on either side

#  |--------------------------------------------|
#  |  < |  1 |  < |  2 |  < |  3 |  < |  4 |  < |
#  |--------------------------------------------|
#  |  5 |  X |  6 |  X |  7 |  X |  8 |  X |  9 |
#  |--------------------------------------------|
#  |  < | 10 |  < | 11 |  < | 12 |  < | 13 |  < |
#  |--------------------------------------------|
#  | 14 |  X | 15 |  X | 16 |  X | 17 |  X | 18 |
#  |============================================|
#  |  < |  A |  < |  B |  < |  C |  < |  D |  < |
#  |============================================|
#  | 14 |  X | 15 |  X | 16 |  X | 17 |  X | 18 |
#  |--------------------------------------------|
#  |  < | 10 |  < | 11 |  < | 12 |  < | 13 |  < |
#  |--------------------------------------------|
#  |  5 |  X |  6 |  X |  7 |  X |  8 |  X |  9 |
#  |--------------------------------------------|
#  |  < |  1 |  < |  2 |  < |  3 |  < |  4 |  < |
#  |--------------------------------------------|

#           Symmetric about the E plane axis
#              TOTAL NUMBER OF BITS = 488

# maps the switch states so that the array is symetric about the E plane
# bit ordeer is left to right, top to bottom by switch and then by sheet
class EPlaneMirror(Mapper.Mapper):
    # intializes the mapper
    # index map is a dictionary
    # return type: self
    def __init__(self):
        indexMap = {}
        bit_idx = 0
        # assign top half of array new bits
        for sheet_y in range(4,0,-1):
            for sheet_x in range(-4,5,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = bit_idx
                                bit_idx += 1
        # assign top half of center row of sheets new bits
        for sheet_y in [0]:
            for sheet_x in range(-4,5,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-1,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = bit_idx
                                bit_idx += 1
        # assign bottom half of center row of sheets mirrored bits
        for sheet_y in [0]:
            for sheet_x in range(-4,5,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(-1,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                mirror_coordinates = (sheet_x,sheet_y,switch_x,-1*switch_y)
                                bit_loc = indexMap[mirror_coordinates]
                                indexMap[coordinates] = bit_loc
        # assign bottom half of array mirrored bits
        for sheet_y in range(-1,-5,-1):
            for sheet_x in range(-4,5,1):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_y in range(3,-4,-1):
                        for switch_x in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                mirror_coordinates = (sheet_x,-1*sheet_y,switch_x,-1*switch_y)
                                bit_loc = indexMap[mirror_coordinates]
                                indexMap[coordinates] = bit_loc
        # assign unused sheets to same bit (BIT 0)
        for sheet_y in [-5]:
            for sheet_x in range(-4,6):
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_x in range(-3,4,1):
                        for switch_y in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = 0
        for sheet_y in range(-4,6):
            for sheet_x in [-5]:
                num_sheet_steps = (abs(sheet_x)+abs(sheet_y))%2
                if num_sheet_steps != 0:
                    for switch_x in range(-3,4,1):
                        for switch_y in range(-3,4,1):
                            num_switch_steps = (abs(switch_x)+abs(switch_y))%2
                            if num_switch_steps != 0:
                                coordinates = (sheet_x,sheet_y,switch_x,switch_y)
                                indexMap[coordinates] = 0
        super(EPlaneMirror,self).__init__(488,indexMap)
